/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.relics;

import com.megacrit.cardcrawl.actions.common.GainBlockAction;
import com.megacrit.cardcrawl.actions.common.RelicAboveCreatureAction;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.relics.AbstractRelic;

public class Orichalcum
extends AbstractRelic {
    public static final String ID = "Orichalcum";
    private static final int BLOCK_AMT = 6;

    public Orichalcum() {
        super(ID, "orichalcum.png", AbstractRelic.RelicTier.COMMON, AbstractRelic.LandingSound.HEAVY);
    }

    @Override
    public String getUpdatedDescription() {
        return this.DESCRIPTIONS[0] + 6 + this.DESCRIPTIONS[1];
    }

    @Override
    public void onPlayerEndTurn() {
        if (AbstractDungeon.player.currentBlock == 0) {
            this.flash();
            this.stopPulse();
            AbstractDungeon.actionManager.addToTop(new GainBlockAction(AbstractDungeon.player, AbstractDungeon.player, 6));
            AbstractDungeon.actionManager.addToTop(new RelicAboveCreatureAction(AbstractDungeon.player, this));
        }
    }

    @Override
    public void atTurnStart() {
        this.beginLongPulse();
    }

    @Override
    public int onPlayerGainBlock(int blockAmount) {
        if (blockAmount > 0) {
            this.stopPulse();
        }
        return blockAmount;
    }

    @Override
    public void onVictory() {
        this.stopPulse();
    }

    @Override
    public AbstractRelic makeCopy() {
        return new Orichalcum();
    }
}

